<?php
$abspath = preg_replace('/\\\/', '/', dirname(dirname(__FILE__)));
if (!file_exists($abspath . '/configs/config.php')) {
    require $abspath . '/includes/functions.php';
    redirect_to_install($abspath);
}
require $abspath . '/configs/config.php';
session_name('PageFlex' .sha1(__SECURITY_SALT__ . __SECURITY_CIPHER_SEED__));
@session_start();
require ABSPATH . '/includes/helper/url-helper.php';
require ABSPATH . '/includes/error-handler-class.php';
require ABSPATH . '/includes/pf-class.php';
require ABSPATH . '/admin/plugins/user/class/authentication/auth.php';
require ABSPATH . '/admin/plugins/user/class/pf-user.php';
require ABSPATH . '/admin/includes/option.php';
require ABSPATH . '/includes/functions.php';
require ABSPATH . '/admin/includes/functions.php';

require ABSPATH . '/includes/paginator-class.php';
require ABSPATH . '/includes/helper/form-helper.php';
require ABSPATH . '/includes/File_Gettext/File/Gettext.php';
require ABSPATH . '/includes/helper/l10n-helper.php';
require ABSPATH . '/includes/widget-class.php';
require ABSPATH . '/includes/plugin-class.php';


$sitename   =   Pf::setting()->get_element_value('general','site_name');
if (is_login() == TRUE) {
    if (isset($_GET['action']) && $_GET['action'] == 'logout') {
        $auth = new Auth();
        $auth->destroy_session();
        
        if($auth->check_cookie('id')){
            $auth->destroy_cookie('id');
        }
        header('location: ?page=login');
    } else {
        header('location: index.php');
    }
} else {
    if (!isset($_GET['page'])) {
        if (!empty($_GET['ref'])) {
            header('location: ?page=login&ref=' . urlencode($_GET['ref']));
        } else
            header('location: ?page=login');
    }
}
?>
<html class="bg-black">
    <head>
        <meta charset="UTF-8">
        <title><?php echo $sitename." | ".__('Login','user'); ?></title>
        <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
        <!-- bootstrap 3.0.2 -->
        <link href="themes/default/assets/bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
        <!-- font Awesome -->
        <link href="themes/default/assets/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
        <!-- Theme style -->
        <link href="themes/default/assets/admin-lte/css/AdminLTE.css" rel="stylesheet" type="text/css" />
                <!-- jQuery 2.0.2 -->
        <script src="//ajax.googleapis.com/ajax/libs/jquery/2.0.2/jquery.min.js"></script>
        <!-- Bootstrap -->
        <script src="themes/default/assets/bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
        <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
          <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
          <script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
        <![endif]-->
    </head>
    <body class="bg-black">
<?php
    require ABSPATH . "/admin/plugins/user/backend/login.php";
?>
    </body>
</html>